/*
 *  lighttemp.h
 *  
 *
 *  Created by Kat Dornian (Phidgets Inc) on 2014-05-31
 *  This file is part of nightlight.
 *  
 *  Nightlight is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Nightlight is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You can see the GNU General Public License at 
 *  <http://www.gnu.org/licenses/>.
 *
 */

#define RUG_SWITCH_INPUT 7
#define RED_1 0
#define RED_2 1
#define GREEN_1 2
#define GREEN_2 3
#define BLUE_1 4
#define BLUE_2 5 
#define TEMPERATURE 0
#define DISTANCE 2
// Temperatures are in Kelvins
#define LOWEST_TEMP 266
#define TEMP_1 278
#define TEMP_2 285
#define TEMP_3 293
#define HIGHEST_TEMP 300

int CCONV AttachHandler(CPhidgetHandle IFK, void *userptr);
int CCONV DetachHandler(CPhidgetHandle IFK, void *userptr);
int CCONV ErrorHandler(CPhidgetHandle IFK, void *userptr, int ErrorCode, const char *unknown);
int CCONV InputChangeHandler(CPhidgetInterfaceKitHandle IFK, void *usrptr, int Index, int State);
int CCONV OutputChangeHandler(CPhidgetInterfaceKitHandle IFK, void *usrptr, int Index, int State);
int CCONV SensorChangeHandler(CPhidgetInterfaceKitHandle IFK, void *usrptr, int Index, int Value);
int display_properties(CPhidgetInterfaceKitHandle phid);
int interfacekit_simple();